function [ M ] = changePointDetection( A )
%This function implements the dynamic programming algorithm in the case
%when the number of clusters is unknown a priori, namely max_{M \in \mathcal{M}}
% The input is an affinity matrix A.

T           = size(A, 1);

cost        = zeros(T,T);
imageInt    = cumsum(cumsum(A,2));


for t=0:(T-1)

%    cost(t+1,t+1)=mBax(cost(:,t))+cout(imageint,t+1,t+1);
if t == 0
    tmp = 0;
else
    [tmp]=max(cost(1:t,t));
end    
    for u=(t+1):T
        cost(t+1,u)=tmp + cout(imageInt,t+1,u);
    end
end


%% Backtracking step to get the Y

argmax = T+1;
segmentation = argmax;

while argmax>1

    [~, argmax]  = max(cost(1:argmax-1, argmax - 1));
    segmentation = [argmax, segmentation]; 
    
end

nSegs = length(segmentation) - 1;
Y = zeros(T, nSegs);

% 
for i = 1:length(segmentation) - 1

    Y(segmentation(i) : segmentation(i+1) - 1, i) = 1;
    
end


M = getMFromY(Y);

end

