function objective = computeObjective(B, lambda, labelTrain, dataTrain, params)

nTrain = length(dataTrain);


objective = 0;


% compute the hinge loss for each of the training examples
for i = 1:nTrain
    
    exampleData = dataTrain{i};
    exampleLabel = labelTrain{i};
    T = length(exampleLabel);
    
    if ~params.rescaled
        
        A = (exampleData*B*exampleData'-2*exampleLabel);
        
    else
        
        A = (exampleData*B*exampleData' - eye(T) + (1/T) * eye(T) - 2*exampleLabel/T);
        
    end
    
    Nopt = changePointDetection(A);
    
    if ~params.rescaled
        obj  =  norm(exampleLabel - Nopt, 'fro')^2 ...
            + trace((Nopt - exampleLabel) * (exampleData * B * exampleData' - eye(T)));
    else
        obj  = 1/T * norm(exampleLabel - Nopt, 'fro')^2 ...
            + trace((Nopt - exampleLabel) * (exampleData * B * exampleData' - eye(T)));
    end
    objective = objective + 1/nTrain * obj;
    
end

objective = lambda / 2 * norm(B, 'fro')^2 + objective;

end