function [data, groundtruth] = generateData(n, p, K, T)
% This function implements the toy generation method used for the paper by
% Lajugie, Arlot and Bach (ICML 2014)
% p is the dimension of the temporal time series
% K is the number of breakpoints
% T is the common length of the time series
% dist is the number of disturbing dimensions
% outputs are n time series with associated groundtruth
% Note that it is straightforward to extend this code to generate series
% of different length or with different number of breakpoints


for i = 1:n
    
    bkp                   = [0, cumsum(mnrnd(T, (1/K) * ones(1, K)))];
    disturbingBreakpoints = [0, cumsum(mnrnd(T, (1/ceil(K*3/2)) * ones(1, ceil(K*3/2))))];
    ground                = zeros(T, K);
    dat                   = zeros(T, p);
    
    for j = 1:K
        
        % The groundtruth dimension
        ground((bkp(j) + 1): bkp(j+1), j) = 1;
        dat((bkp(j) + 1):bkp(j+1), 1) = j ...
            + .1 * randn( bkp(j+1) -bkp(j), 1);
        
        
        
    end
    
    for j = 1:(ceil(K*3/2))
        % Others series are disturbing
        for k = 2:p
            dat((disturbingBreakpoints(j) + 1) : disturbingBreakpoints(j+1), k) = j ...
                + .1 * randn( disturbingBreakpoints(j+1) - disturbingBreakpoints(j), 1);
        end
    end
    data{i} = dat;
    groundtruth{i} = ground;
end

end