function [] = dbGradient(z, y, yExpected, gradient, X, mu, nu, phi, GXTP, params)  

    f1 = [];    
    gams  = logspace(-8, -1, 20);
    figure(1)
    clf()
    
    y0 = y;
        zTemp = z;
        yTemp = y;
        f0 = computeObjective(X, zTemp, yTemp, yExpected, mu, nu, GXTP, params);
    
        f1 = zeros(8, 20);
        f2 = f1;
        for u = 1:8
            [a, b] = generateRand(y, phi);
            a = cell2mat(a);
            for t = 1:length(gams)
                
                yTemp = updateYDebug(gams(t), y, b);
                zTemp = z + gams(t) * (a');
                f1(u,t) = computeObjective(X, zTemp, yTemp, yExpected, mu, nu, GXTP, params);
                deltaf = (f1(u, t) - f0) / (gams(t) * gradTimesY(gradient, b));
                f2(u, t) = deltaf;
            end
            hold on
            plot(f2(u, :));
            drawnow()
        end
end