function [perfVal, obj] = experimentY(datapath, saveDir, lambda, mu, seed, params)



rng(seed);



% Get the data


[x, gt, yGt, phi, eventList, params, longueurs, yExpected] = getData(datapath, params);

%%%%%%%%%%%%%% Cheap and efficient block

% for i = 1:length(eventList)
% 
%     eventList{i}(end) = eventList{i}(end - 1);
%     
% end

%%%%%%%%%%%%%%% end of cheap and efficient block

% concatenating the groundtruth

zGt = cell2mat(gt');
yGt = (yGt);

% getting the size of all the data
[N, K]  = size(zGt);

% initializing with an interior point

if params.silence == 0
    K = K + 1;
    [z, y] = getInteriorPoint(N, K, eventList, longueurs);
    z = z(:, 2:end);
else
[z, y] = getInteriorPoint(N, K, eventList, longueurs);
end
% Launching the optim procedure

yExpected = yGt;

[perfVal ] = frankWolfeOptimizationY( ...
    x, zGt, yGt, yExpected, eventList, longueurs, K, z, y, phi, lambda, mu, params );

saveFile = fullfile(saveDir, params.saveString);
save(saveFile, 'perfVal');