function [perfTrain, perfVal, perfTest, roundTrain, params, delayTrainVariant, delayValVariant, delayTestVariant] = experimentYFinlandais(lambda, mu, nu, nTrain, seed, params)

datapath = params.dataPath;
saveDir  = params.saveDir;

params.nTrain = nTrain + params.nVal + params.nTest;
rng(seed+1);



% Get the data


[x, gt, yGt, phi, eventList, params, longueurs, yExpected] = getDataFinland(datapath, params);

%%%%%%%%%%%%%% Cheap and efficient block

% for i = 1:length(eventList)
% 
%     eventList{i}(end) = eventList{i}(end - 1);
%     
% end

%%%%%%%%%%%%%%% end of cheap and efficient block

% concatenating the groundtruth


l = length(yGt);
u = randperm(l);
indicesTrain = u(1:nTrain);
indicesVal   = u(nTrain+1:nTrain+params.nVal);
indicesTest  = u(nTrain+params.nVal+1:nTrain+params.nVal+params.nTest);


[xTrain, gtTrain, yGtTrain, phiTrain, eventListTrain, yExpectedTrain, longueursTrain] = splitDataset(x, gt, yGt, phi, eventList, yExpected, longueurs, indicesTrain);
XTrain       = cell2mat(xTrain);
zGtTrain     = cell2mat(gtTrain');
yGtTrain     = (yGtTrain');
[NTrain, K]  = size(zGtTrain);

% initializing with an interior point

if params.silence == 0
    K = K + 1;
    [z, y] = getInteriorPoint(NTrain, K, eventListTrain, longueursTrain);
    z = z(:, 2:end);
else
[z, y] = getInteriorPoint(NTrain, K, eventListTrain, longueursTrain);
end

%Initialize from the groundtruth

% z              = zGtTrain;
% 
% 
% for i = 1:length(yGtTrain)
%     y{i} = yGtTrain{i}';
% end

% Launching the optim procedure



[perfTrain ] = frankWolfeOptimizationY( ...
    XTrain', zGtTrain, yGtTrain, yExpectedTrain, eventListTrain, longueursTrain, K, z, y, phiTrain, lambda, mu, nu, params );
save('toto', 'perfTrain')

[~, yTrainPred, ~, yTrainPredVariant]         =  computeTestError(xTrain, perfTrain.w, perfTrain.b, eventListTrain, phiTrain, params);
[perfTrainbis, delayTrain] = lossAlignments(yGtTrain, yTrainPred, K, longueursTrain, params);
[perfTrainbisVariant, delayTrainVariant] = lossAlignments(yGtTrain, yTrainPredVariant, K, longueursTrain, params);


[xVal, gtVal, yGtVal, phiVal, eventListVal, yExpectedVal, longueursVal] = splitDataset(x, gt, yGt, phi, eventList, yExpected, longueurs, indicesVal);



[~, yValPred, ~, yValPredVariant]       =  computeTestError(xVal, perfTrain.w, perfTrain.b, eventListVal, phiVal, params);
[perfVal, delayVal] = lossAlignments(yGtVal, yValPred, K, longueursVal, params);
[perfValbisVariant, delayValVariant] = lossAlignments(yGtVal, yValPredVariant, K, longueursTrain, params);

[xTest, gtTest, yGtTest, phiTest, eventListTest, yExpectedTest, longueursTest] = splitDataset(x, gt, yGt, phi, eventList, yExpected, longueurs, indicesTest);

[~, yTestPred, ~, yTestPredVariant]        =  computeTestError(xTest, perfTrain.w, perfTrain.b, eventListTest, phiTest, params);
[perfTest, delayTest] = lossAlignments(yGtTest, yTestPred, K, longueursTest, params);
[perfTestbisVariant, delayTestVariant] = lossAlignments(yGtTest, yTestPredVariant, K, longueursTrain, params);

perfTrain.baselineTrain = lossAlignments(yGtTrain, yExpectedTrain, K, longueursTrain, params);
perfTrain.baselineVal   = lossAlignments(yGtVal, yExpectedVal, K, longueursVal, params);
perfTrain.baselineTest  = lossAlignments(yGtTest, yExpectedTest, K, longueursTest, params);


params.mu     = mu;
params.nTrain = nTrain;
params.lambda = lambda;
perfVal       = delayVal;
perfTest      = delayTest;
roundTrain    = delayTrain;  
params.w = perfTrain.w;
saveFile = fullfile(saveDir, params.saveString);

save(saveFile, 'perfVal', 'delayVal', 'params', 'perfTrain', 'perfTest');