function [x, gt1, yGt, phi, eventList, params, longueurs, yExpected] = getData(datapath, params)


names = dir([datapath, '/*.mat']);
N     = length(names);
longueurs = zeros(1, N);

if strcmp(params.features, 'constantQHalf')
    if params.midi == 1
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = constantQHalfMidi;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);    
            
            if(params.silence == 0)
                gtMidi = gtMidi(:, 2:end);
            end
            
            gt1{i}                              = gtMidi;
            longueurs(i)                        = size(x{i}, 2);
        end
        
    else
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = constantQHalf;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gT);     
            
            if(params.silence == 0)
                gT = gT(:, 2:end);
            end
            
            gt1{i}                              = gT;
            longueurs(i)                        = size(x{i}, 2);
            
        end
        
    end
    
elseif strcmp(params.features, 'toy')
    if params.midi == 1
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = gtMidi(:, 2:end)';

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);    
            
            if(params.silence == 0)
                gtMidi = gtMidi(:, 2:end);
            end
            
            gt1{i}                              = gtMidi;
            longueurs(i)                        = size(x{i}, 2);
        end
        
    else
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = gT(:, 2:end)';

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gT);     
            
            if(params.silence == 0)
                gT = gT(:, 2:end);
            end
            gt1{i}                              = gT;
            longueurs(i)                        = size(x{i}, 2);
            
        end
        
    end
    
elseif strcmp(params.features, 'constantQQuarter')
    if params.midi == 1
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = constantQQuarterMidi;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);    
            if(params.silence == 0)
                gtMidi = gtMidi(:, 2:end);
            end
            gt1{i}                              = gtMidi;
            longueurs(i)                        = size(x{i}, 2);
        end
        
    else
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = constantQQuarter;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gT);     
            
            if(params.silence == 0)
                gT = gT(:, 2:end);
            end
            
            gt1{i}                              = gT;
            longueurs(i)                        = size(x{i}, 2);
            
        end
        
    end
    
elseif strcmp(params.features, 'melSpectrogram')
    if params.midi == 1
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = melSpectrogramMidi;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);    
            if(params.silence == 0)
                gtMidi = gtMidi(:, 2:end);
            end
            gt1{i}                              = gtMidi;
            longueurs(i)                        = size(x{i}, 2);
        end
        
    else
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = melSpectrogram;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gT);     
            
            if(params.silence == 0)
                gT = gT(:, 2:end);
            end
            gt1{i}                              = gT;
            longueurs(i)                        = size(x{i}, 2);
            
        end
        
    end
    
elseif strcmp(params.features, 'Cepstrogram')
    if params.midi == 1
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = featuresCepstrogramMidi;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);    
            if(params.silence == 0)
                gtMidi = gtMidi(:, 2:end);
            end
            gt1{i}                              = gtMidi;
            longueurs(i)                        = size(x{i}, 2);
        end
        
    else
        
        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            x{i}                                = featuresCepstrogram;

            [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gT);     
            
            if(params.silence == 0)
                gT = gT(:, 2:end);
            end
            gt1{i}                              = gT;
            longueurs(i)                        = size(x{i}, 2);
            
        end
        
    end
    
    
end


% Now, let's get the ``expected alignment''

        for i = 1:N
            
            load(fullfile(datapath, names(i).name));
            li = size(x{i}, 2);
            [yMid, ~, ~]      = yFromGt(gtMidi);
            lMid = size(yMid, 1);
            yExp = zeros(li, size(yMid, 2));
            
            for j = 1:li
                
                yExp(j, :) = yMid(max(round(j * lMid/li), 1), :);
                
            end
            
            yExpected{i} = yExp;
        end

params.dico    = params;
params.hopSize = timeIndex(2) - timeIndex(1); 
end