function [x, gt, yGt, phi, eventList, params, longueurs, yExpected] = getDataFinland(datapath, params)



names = dir([datapath, '/*.mat']);
N     = params.nTrain;
longueurs = zeros(1, N);

if strcmp(params.features, 'melSpectrogram')
    
for i = 1:N
    
    load(fullfile(datapath, names(i).name));
    x{i}                                = melSpectrogramMidi;
    
    [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);
    
    if(params.silence == 0)
        gtMidi = gtMidi(:, 2:end);
    end
    
    gt{i}                               = gtMidi;
    longueurs(i)                        = size(x{i}, 2);
end

elseif strcmp(params.features, 'spectrogram')
       
    for i = 1:N
    i
    load(fullfile(datapath, names(i).name));
    x{i}                                = spectrogramMidi'./norm(spectrogramMidi, 'fro');
    x{i}                                = double(x{i}(1:1000, :));
    x{i}                                = ((x{i}+eps)./(repmat(sqrt(sum((x{i}+eps).^2, 1)), size(x{i}, 1), 1)));
    [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);
    
    if(params.silence == 0)
        gtMidi = gtMidi(:, 2:end);
    end
    
    gt{i}                              = gtMidi;
    longueurs(i)                       = size(x{i}, 2);
    end
else
    
for i = 1:N
    
    load(fullfile(datapath, names(i).name));
    x{i}                                = constantQHalfMidi;
    
    [yGt{i}, phi{i}, eventList{i}]      = yFromGt(gtMidi);
    
    if(params.silence == 0)
        gtMidi = gtMidi(:, 2:end);
    end
    
    gt{i}                              = gtMidi;
    longueurs(i)                        = size(x{i}, 2);
end

end

% Now, let's get the ``expected alignment''


if params.yExpected == 1

    for i = 1:N
    
        load(fullfile(datapath, names(i).name));
        yExpected{i} = yFromGt(gtExpected);
        

    end

else
    
    for i = 1:N
    
    load(fullfile(datapath, names(i).name));
    li = size(x{i}, 2);
    [yMid, ~, ~]      = yFromGt(gtMidi);
    lMid = size(yMid, 1);
    yExp = zeros(li, size(yMid, 2));
    
   
   for j = 1:li
        
        yExp(j, :) = yMid(max(round(j * lMid/li), 1), :);
        
    end
    
    yExpected{i} = yExp;

    end
end

params.dico    = params;
params.hopSize = 0.08;

end