function [z, y] = getInteriorPoint(N, K, eventList, longueurs)
%This function aims at finding an interior point to start the FW
%optimization.

n1 = 10;
z  = zeros(sum(longueurs), K);
y  = {};

for i = 1:n1
    
    zTA    = randn(K, sum(longueurs));
    l      = mat2cell(zTA, K, longueurs);
    [a, b] = optimizeA(l, K, eventList);
    a      = cell2mat(a');
    z      = z + a';
    
    for j = 1:length(b)
        if i == 1
            y{j}      = 1/n1 * b{j};
        else
            y{j}      = y{j} + 1/n1 * b{j};
        end
    end
    
end

z = z/n1;

end