function [l, delay] = lossAlignments(Y, Y1, K, longueurs, params)

% Recover all the pieces of music

y  = Y;
y1 = Y1;
N  = length(y);
l  = 0;
d  = 0; 

for i = 1:N

    Y  = y{i}';
    Y1 = y1{i};
    nEvents = size(Y, 1);

    if (size(Y1, 2) == size(Y, 1)) && (size(Y1, 1) == size(Y, 2))
    
        Y1 = Y1';
        
    end
    
    L  = tril(ones(nEvents), -1);

    n  = norm(L * Y - L * Y1, 'fro')^2; 
    l  = l + n;
    d  = d + n * params.hopSize/(nEvents);

end

l     = l/N;
delay = d/N;

end 