function l = lossAssignments(Y, Y1, K, longueurs, params)

% Recover all the pieces of music

if params.silence == 0
    silences = 1 - ones(1, K-1) * Y;
    Y        = [silences ; Y];
end

y  = mat2cell(Y, K, longueurs);
y1 = mat2cell(Y1, K, longueurs);
N  = length(y);

l = 0;
d = 0;

for i = 1:N

    Y  = y{i};
    Y1 = y1{i};
    L  = tril(ones(size(Y, 1)));
    n  = norm(L * Y - L * Y1, 'fro')^2;
    l  = l + n;
    d  = d + n * params.hopSize;

end

l = l/N;

end 