function [a, b] = optimizeA(l, K, annot)

a = cell(length(l), 1);

for i = 1:length(l)

    k = annot{i};
    % building the cost matrix
    C = l{i}(k, :);
    
    [~, path, ~] = warping_mex(C);
    
    fullPath = full(sparse(path(:, 1), path(:, 2), ones(size(path, 1), 1)));
    b{i}     = fullPath;
    aInt     = full(sparse(k(path(:, 1)), (path(:, 2)), 1));
    aTemp    = zeros(K, size(aInt, 2));
    aTemp(1:size(aInt, 1), 1:size(aInt, 2)) = aInt;
    a{i}     = aTemp;
end

end