function [a, b] = optimizeAY(l, phi, params)

a = cell(length(l), 1);

for i = 1:length(l)

    % building the cost matrix
    C = l{i};
    
    [~, path, ~] = warping_mex(C);
    
    fullPath = full(sparse(path(:, 1), path(:, 2), ones(size(path, 1), 1)));
    b{i}     = fullPath;

end

%Cheap and Efficient.
param.silence = 1;
a = getZFromY(b, phi, param);

end